<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Servis Kaydı Detayı') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if (session('success'))
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <!-- Cihaz Bilgileri -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Cihaz Bilgileri</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-500">Takip No</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->tracking_number }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Marka</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->brand }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Model</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->model }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Seri No</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->serial_number }}</p>
                            </div>
                            <div class="md:col-span-2">
                                <p class="text-sm text-gray-500">Arıza Açıklaması</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->fault_description }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Müşteri Bilgileri -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Müşteri Bilgileri</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-500">Ad Soyad</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->customer->name }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Telefon</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->customer->phone }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Servis Durumu -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Servis Durumu</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-500">Durum</p>
                                @php
                                    $statusColors = [
                                        'pending' => 'bg-yellow-100 text-yellow-800',
                                        'in_progress' => 'bg-blue-100 text-blue-800',
                                        'waiting_for_parts' => 'bg-red-100 text-red-800',
                                        'completed' => 'bg-green-100 text-green-800',
                                        'cancelled' => 'bg-gray-100 text-gray-800'
                                    ];
                                    $statusLabels = [
                                        'pending' => 'Beklemede',
                                        'in_progress' => 'İşlemde',
                                        'waiting_for_parts' => 'Parça Bekliyor',
                                        'completed' => 'Tamamlandı',
                                        'cancelled' => 'İptal Edildi'
                                    ];
                                @endphp
                                <span class="mt-1 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $statusColors[$serviceRecord->status] }}">
                                    {{ $statusLabels[$serviceRecord->status] }}
                                </span>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Öncelik</p>
                                @php
                                    $priorityColors = [
                                        'high' => 'bg-red-100 text-red-800',
                                        'medium' => 'bg-yellow-100 text-yellow-800',
                                        'low' => 'bg-green-100 text-green-800'
                                    ];
                                    $priorityLabels = [
                                        'high' => 'Yüksek',
                                        'medium' => 'Orta',
                                        'low' => 'Düşük'
                                    ];
                                @endphp
                                <span class="mt-1 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $priorityColors[$serviceRecord->priority] }}">
                                    {{ $priorityLabels[$serviceRecord->priority] }}
                                </span>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Oluşturulma Tarihi</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->created_at->format('d.m.Y H:i') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Son Güncelleme</p>
                                <p class="mt-1 text-sm text-gray-900">{{ $serviceRecord->updated_at->format('d.m.Y H:i') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Durum Güncelleme Formu -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Durum Güncelle</h3>
                        <form action="{{ route('technician.service-records.update-status', $serviceRecord) }}" method="POST" class="space-y-4">
                            @csrf
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700">Yeni Durum</label>
                                <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="pending" {{ $serviceRecord->status === 'pending' ? 'selected' : '' }}>Beklemede</option>
                                    <option value="in_progress" {{ $serviceRecord->status === 'in_progress' ? 'selected' : '' }}>İşlemde</option>
                                    <option value="waiting_for_parts" {{ $serviceRecord->status === 'waiting_for_parts' ? 'selected' : '' }}>Parça Bekliyor</option>
                                    <option value="completed" {{ $serviceRecord->status === 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                                    <option value="cancelled" {{ $serviceRecord->status === 'cancelled' ? 'selected' : '' }}>İptal Edildi</option>
                                </select>
                            </div>
                            <div>
                                <label for="note" class="block text-sm font-medium text-gray-700">Not</label>
                                <textarea name="note" id="note" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required></textarea>
                            </div>
                            <div class="flex justify-end">
                                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Durumu Güncelle
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Parça Talebi Formu -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Parça Talebi Oluştur</h3>
                        <form action="{{ route('technician.parts.request', $serviceRecord) }}" method="POST" class="space-y-4">
                            @csrf
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="part_name" class="block text-sm font-medium text-gray-700">Parça Adı</label>
                                    <input type="text" name="part_name" id="part_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>
                                <div>
                                    <label for="part_code" class="block text-sm font-medium text-gray-700">Parça Kodu</label>
                                    <input type="text" name="part_code" id="part_code" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="quantity" class="block text-sm font-medium text-gray-700">Adet</label>
                                    <input type="number" name="quantity" id="quantity" min="1" value="1" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>
                                <div>
                                    <label for="description" class="block text-sm font-medium text-gray-700">Açıklama</label>
                                    <textarea name="description" id="description" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                                </div>
                            </div>
                            <div class="flex justify-end">
                                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Parça Talebi Oluştur
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Not Ekleme Formu -->
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Not Ekle</h3>
                        <form action="{{ route('technician.service-records.add-note', $serviceRecord) }}" method="POST" class="space-y-4">
                            @csrf
                            <div>
                                <label for="note_type" class="block text-sm font-medium text-gray-700">Not Tipi</label>
                                <select name="type" id="note_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="technician_note">Tekniker Notu</option>
                                    <option value="general">Genel Not</option>
                                </select>
                            </div>
                            <div>
                                <label for="note_content" class="block text-sm font-medium text-gray-700">Not İçeriği</label>
                                <textarea name="content" id="note_content" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required></textarea>
                            </div>
                            <div class="flex justify-end">
                                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Not Ekle
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Notlar -->
                    <div>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Notlar</h3>
                        <div class="space-y-4">
                            @forelse($serviceRecord->notes as $note)
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <p class="text-sm text-gray-900">{{ $note->content }}</p>
                                            <p class="mt-1 text-xs text-gray-500">
                                                @php
                                                    $noteTypes = [
                                                        'status_change' => 'Durum Değişikliği',
                                                        'technician_note' => 'Tekniker Notu',
                                                        'general' => 'Genel Not'
                                                    ];
                                                @endphp
                                                {{ $noteTypes[$note->type] }} - {{ $note->created_at->format('d.m.Y H:i') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <p class="text-sm text-gray-500">Henüz not eklenmemiş.</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 