@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0">{{ __('Servis Kaydı Detayı') }}</h2>
        <div class="d-flex gap-2">
            <a href="{{ route('service-records.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>{{ __('Geri Dön') }}
            </a>
            @can('update', $serviceRecord)
                <a href="{{ route('service-records.edit', $serviceRecord) }}" class="btn btn-primary">
                    <i class="fas fa-edit me-2"></i>{{ __('Düzenle') }}
                </a>
            @endcan
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <!-- Servis Kaydı Bilgileri -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h3 class="h5 mb-3">{{ __('Müşteri Bilgileri') }}</h3>
                    <dl class="row">
                        <dt class="col-sm-4">{{ __('Ad Soyad') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->customer_name }}</dd>

                        <dt class="col-sm-4">{{ __('Telefon') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->customer_phone }}</dd>

                        <dt class="col-sm-4">{{ __('E-posta') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->customer_email }}</dd>

                        <dt class="col-sm-4">{{ __('Adres') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->customer_address }}</dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h3 class="h5 mb-3">{{ __('Cihaz Bilgileri') }}</h3>
                    <dl class="row">
                        <dt class="col-sm-4">{{ __('Marka') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->device_brand }}</dd>

                        <dt class="col-sm-4">{{ __('Model') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->device_model }}</dd>

                        <dt class="col-sm-4">{{ __('Seri No') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->device_serial_number }}</dd>

                        <dt class="col-sm-4">{{ __('Arıza Açıklaması') }}</dt>
                        <dd class="col-sm-8">{{ $serviceRecord->fault_description }}</dd>
                    </dl>
                </div>
            </div>

            <!-- Durum ve Teknisyen Bilgileri -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h3 class="h5 mb-3">{{ __('Servis Durumu') }}</h3>
                    <div class="d-flex align-items-center gap-3">
                        <span class="badge 
                            @if($serviceRecord->status == 'pending') bg-warning
                            @elseif($serviceRecord->status == 'in_progress') bg-primary
                            @elseif($serviceRecord->status == 'completed') bg-success
                            @elseif($serviceRecord->status == 'cancelled') bg-danger
                            @endif">
                            {{ $serviceRecord->status_text }}
                        </span>
                        @can('change-status', $serviceRecord)
                            <button type="button" onclick="openStatusModal()" class="btn btn-link p-0">
                                <i class="fas fa-exchange-alt me-1"></i>{{ __('Durum Değiştir') }}
                            </button>
                        @endcan
                    </div>
                </div>

                <div class="col-md-6">
                    <h3 class="h5 mb-3">{{ __('Teknisyen') }}</h3>
                    <div class="d-flex align-items-center gap-3">
                        @if($serviceRecord->technician)
                            <span>{{ $serviceRecord->technician->name }}</span>
                        @else
                            <span class="text-muted">{{ __('Atanmadı') }}</span>
                        @endif
                        @can('assign-technician', $serviceRecord)
                            <button type="button" onclick="openTechnicianModal()" class="btn btn-link p-0">
                                <i class="fas fa-user-plus me-1"></i>{{ __('Teknisyen Ata') }}
                            </button>
                        @endcan
                    </div>
                </div>
            </div>

            <!-- Durum Geçmişi -->
            <div class="mb-8">
                <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Durum Geçmişi') }}</h3>
                <div class="flow-root">
                    <ul class="-mb-8">
                        @foreach($serviceRecord->statusChanges as $change)
                            <li>
                                <div class="relative pb-8">
                                    @if(!$loop->last)
                                        <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-200" aria-hidden="true"></span>
                                    @endif
                                    <div class="relative flex space-x-3">
                                        <div>
                                            <span class="h-8 w-8 rounded-full bg-gray-400 flex items-center justify-center ring-8 ring-white">
                                                <svg class="h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                                                </svg>
                                            </span>
                                        </div>
                                        <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                            <div>
                                                <p class="text-sm text-gray-500">
                                                    {{ $change->changedBy->name }} tarafından durum değiştirildi
                                                    <span class="font-medium text-gray-900">{{ $change->old_status_text }}</span>
                                                    'dan
                                                    <span class="font-medium text-gray-900">{{ $change->new_status_text }}</span>
                                                    'a
                                                </p>
                                                @if($change->description)
                                                    <p class="mt-2 text-sm text-gray-700">{{ $change->description }}</p>
                                                @endif
                                            </div>
                                            <div class="text-right text-sm whitespace-nowrap text-gray-500">
                                                <time datetime="{{ $change->created_at }}">{{ $change->created_at->format('d.m.Y H:i') }}</time>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Durum Değiştirme Modal -->
<div id="statusModal" class="fixed z-10 inset-0 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
            <form action="{{ route('service-records.change-status', $serviceRecord) }}" method="POST">
                @csrf
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                        {{ __('Servis Durumu Değiştir') }}
                    </h3>
                    <div class="mt-2">
                        <div class="mt-4">
                            <x-label for="new_status" :value="__('Yeni Durum')" />
                            <x-select id="new_status" name="new_status" class="block mt-1 w-full">
                                @foreach($statuses as $key => $value)
                                    @if($key != $serviceRecord->status)
                                        <option value="{{ $key }}">{{ $value }}</option>
                                    @endif
                                @endforeach
                            </x-select>
                        </div>
                        <div class="mt-4">
                            <x-label for="description" :value="__('Açıklama')" />
                            <x-textarea id="description" name="description" class="block mt-1 w-full" rows="3" />
                        </div>
                        <div class="mt-4">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="notify_customer" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <span class="ml-2 text-sm text-gray-600">{{ __('Müşteriye Bildir') }}</span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="mt-5 sm:mt-6 sm:grid sm:grid-cols-2 sm:gap-3 sm:grid-flow-row-dense">
                    <x-button type="submit" class="w-full justify-center">
                        {{ __('Kaydet') }}
                    </x-button>
                    <button type="button" onclick="closeStatusModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:col-start-1 sm:text-sm">
                        {{ __('İptal') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Teknisyen Atama Modal -->
<div id="technicianModal" class="fixed z-10 inset-0 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
            <form action="{{ route('service-records.assign-technician', $serviceRecord) }}" method="POST">
                @csrf
                <div>
                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                        {{ __('Teknisyen Ata') }}
                    </h3>
                    <div class="mt-2">
                        <div class="mt-4">
                            <x-label for="technician_id" :value="__('Teknisyen')" />
                            <x-select id="technician_id" name="technician_id" class="block mt-1 w-full">
                                <option value="">{{ __('Seçiniz') }}</option>
                                @foreach($technicians as $technician)
                                    <option value="{{ $technician->id }}">{{ $technician->name }}</option>
                                @endforeach
                            </x-select>
                        </div>
                        <div class="mt-4">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="notify_customer" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <span class="ml-2 text-sm text-gray-600">{{ __('Müşteriye Bildir') }}</span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="mt-5 sm:mt-6 sm:grid sm:grid-cols-2 sm:gap-3 sm:grid-flow-row-dense">
                    <x-button type="submit" class="w-full justify-center">
                        {{ __('Kaydet') }}
                    </x-button>
                    <button type="button" onclick="closeTechnicianModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:col-start-1 sm:text-sm">
                        {{ __('İptal') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function openStatusModal() {
        document.getElementById('statusModal').classList.remove('hidden');
    }

    function closeStatusModal() {
        document.getElementById('statusModal').classList.add('hidden');
    }

    function openTechnicianModal() {
        document.getElementById('technicianModal').classList.remove('hidden');
    }

    function closeTechnicianModal() {
        document.getElementById('technicianModal').classList.add('hidden');
    }
</script>
@endpush
@endsection 