@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Servis Durum Raporu</h3>
                    <div class="card-tools">
                        <form action="{{ route('service-records.reports.status') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <label for="start_date" class="mr-2">Başlangıç Tarihi:</label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                            </div>
                            <div class="form-group mr-2">
                                <label for="end_date" class="mr-2">Bitiş Tarihi:</label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                            </div>
                            <button type="submit" class="btn btn-primary">Filtrele</button>
                        </form>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Durum</th>
                                    <th>Toplam Kayıt</th>
                                    <th>Yüzde</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total = $statusReport->sum('total');
                                @endphp
                                @foreach($statusReport as $report)
                                    <tr>
                                        <td>{{ __($report->status) }}</td>
                                        <td>{{ $report->total }}</td>
                                        <td>{{ number_format(($report->total / $total) * 100, 2) }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Toplam</th>
                                    <th>{{ $total }}</th>
                                    <th>100%</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="mt-4">
                        <canvas id="statusChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('statusChart').getContext('2d');
        const data = {
            labels: {!! json_encode($statusReport->pluck('status')->map(function($status) { return __($status); })) !!},
            datasets: [{
                data: {!! json_encode($statusReport->pluck('total')) !!},
                backgroundColor: [
                    '#ff6384',
                    '#36a2eb',
                    '#cc65fe',
                    '#ffce56',
                    '#4bc0c0'
                ]
            }]
        };
        new Chart(ctx, {
            type: 'pie',
            data: data,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: true,
                        text: 'Servis Durumları Dağılımı'
                    }
                }
            }
        });
    });
</script>
@endpush 