@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Teknik Servis Personeli Performans Raporu</h3>
                    <div class="card-tools">
                        <form action="{{ route('service-records.reports.performance') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <label for="start_date" class="mr-2">Başlangıç Tarihi:</label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                            </div>
                            <div class="form-group mr-2">
                                <label for="end_date" class="mr-2">Bitiş Tarihi:</label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                            </div>
                            <button type="submit" class="btn btn-primary">Filtrele</button>
                        </form>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Teknik Servis Personeli</th>
                                    <th>Toplam Kayıt</th>
                                    <th>Tamamlanan Kayıt</th>
                                    <th>Tamamlanma Oranı</th>
                                    <th>Ortalama Tamamlanma Süresi (Saat)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($performanceReport as $report)
                                    <tr>
                                        <td>{{ $report->technician->name }}</td>
                                        <td>{{ $report->total_records }}</td>
                                        <td>{{ $report->completed_records }}</td>
                                        <td>{{ number_format(($report->completed_records / $report->total_records) * 100, 2) }}%</td>
                                        <td>{{ number_format($report->avg_completion_time, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <canvas id="completionRateChart"></canvas>
                        </div>
                        <div class="col-md-6">
                            <canvas id="completionTimeChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Tamamlanma Oranı Grafiği
        const completionRateCtx = document.getElementById('completionRateChart').getContext('2d');
        const completionRateData = {
            labels: {!! json_encode($performanceReport->pluck('technician.name')) !!},
            datasets: [{
                label: 'Tamamlanma Oranı (%)',
                data: {!! json_encode($performanceReport->map(function($report) {
                    return number_format(($report->completed_records / $report->total_records) * 100, 2);
                })) !!},
                backgroundColor: '#ff6384',
                borderColor: '#ff6384',
                borderWidth: 1
            }]
        };
        new Chart(completionRateCtx, {
            type: 'bar',
            data: completionRateData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Teknik Servis Personeli Tamamlanma Oranları'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100,
                        ticks: {
                            callback: function(value) {
                                return value + '%';
                            }
                        }
                    }
                }
            }
        });

        // Ortalama Tamamlanma Süresi Grafiği
        const completionTimeCtx = document.getElementById('completionTimeChart').getContext('2d');
        const completionTimeData = {
            labels: {!! json_encode($performanceReport->pluck('technician.name')) !!},
            datasets: [{
                label: 'Ortalama Tamamlanma Süresi (Saat)',
                data: {!! json_encode($performanceReport->pluck('avg_completion_time')) !!},
                backgroundColor: '#ffce56',
                borderColor: '#ffce56',
                borderWidth: 1
            }]
        };
        new Chart(completionTimeCtx, {
            type: 'bar',
            data: completionTimeData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Ortalama Tamamlanma Süreleri'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value + ' saat';
                            }
                        }
                    }
                }
            }
        });
    });
</script>
@endpush 