@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Müşteri Raporu</h3>
                    <div class="card-tools">
                        <form action="{{ route('service-records.reports.customer') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <label for="start_date" class="mr-2">Başlangıç Tarihi:</label>
                                <input type="date" name="start_date" id="start_date" class="form-control" value="{{ $startDate->format('Y-m-d') }}">
                            </div>
                            <div class="form-group mr-2">
                                <label for="end_date" class="mr-2">Bitiş Tarihi:</label>
                                <input type="date" name="end_date" id="end_date" class="form-control" value="{{ $endDate->format('Y-m-d') }}">
                            </div>
                            <button type="submit" class="btn btn-primary">Filtrele</button>
                        </form>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Müşteri</th>
                                    <th>Toplam Servis Kaydı</th>
                                    <th>Yüzde</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total = $customerReport->sum('total');
                                @endphp
                                @foreach($customerReport as $report)
                                    <tr>
                                        <td>{{ $report->customer->name }}</td>
                                        <td>{{ $report->total }}</td>
                                        <td>{{ number_format(($report->total / $total) * 100, 2) }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Toplam</th>
                                    <th>{{ $total }}</th>
                                    <th>100%</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="mt-4">
                        <canvas id="customerChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('customerChart').getContext('2d');
        const data = {
            labels: {!! json_encode($customerReport->pluck('customer.name')) !!},
            datasets: [{
                label: 'Servis Kaydı Sayısı',
                data: {!! json_encode($customerReport->pluck('total')) !!},
                backgroundColor: '#4bc0c0',
                borderColor: '#4bc0c0',
                borderWidth: 1
            }]
        };
        new Chart(ctx, {
            type: 'bar',
            data: data,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Müşteri Bazlı Servis Kaydı Dağılımı'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    });
</script>
@endpush 