@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Servis Kayıtları</h2>
        </div>
        <div class="col-md-6 text-end">
            @can('create', App\Models\ServiceRecord::class)
                <a href="{{ route('service-records.create') }}" class="btn btn-primary">
                    Yeni Servis Kaydı
                </a>
            @endcan
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <!-- Arama ve Filtreleme Formu -->
            <form action="{{ route('service-records.index') }}" method="GET" class="mb-4">
                <div class="row">
                    <!-- Arama -->
                    <div class="col-md-4 mb-3">
                        <label for="search" class="form-label">Arama</label>
                        <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Takip No, Müşteri, Cihaz...">
                    </div>

                    <!-- Durum Filtresi -->
                    <div class="col-md-4 mb-3">
                        <label for="status" class="form-label">Durum</label>
                        <select id="status" name="status" class="form-select">
                            <option value="">Tümü</option>
                            @foreach($statuses as $key => $value)
                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Teknisyen Filtresi -->
                    <div class="col-md-4 mb-3">
                        <label for="technician_id" class="form-label">Teknisyen</label>
                        <select id="technician_id" name="technician_id" class="form-select">
                            <option value="">Tümü</option>
                            @foreach($technicians as $technician)
                                <option value="{{ $technician->id }}" {{ request('technician_id') == $technician->id ? 'selected' : '' }}>{{ $technician->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row">
                    <!-- Tarih Aralığı -->
                    <div class="col-md-6 mb-3">
                        <label for="date_from" class="form-label">Başlangıç Tarihi</label>
                        <input type="date" class="form-control" id="date_from" name="date_from" value="{{ request('date_from') }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="date_to" class="form-label">Bitiş Tarihi</label>
                        <input type="date" class="form-control" id="date_to" name="date_to" value="{{ request('date_to') }}">
                    </div>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-primary">Filtrele</button>
                </div>
            </form>

            <!-- Servis Kayıtları Tablosu -->
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>
                                <a href="{{ route('service-records.index', array_merge(request()->query(), ['sort' => 'tracking_number', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc'])) }}">
                                    Takip No
                                    @if(request('sort') == 'tracking_number')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Müşteri</th>
                            <th>Cihaz</th>
                            <th>
                                <a href="{{ route('service-records.index', array_merge(request()->query(), ['sort' => 'status', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc'])) }}">
                                    Durum
                                    @if(request('sort') == 'status')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Teknisyen</th>
                            <th>
                                <a href="{{ route('service-records.index', array_merge(request()->query(), ['sort' => 'created_at', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc'])) }}">
                                    Oluşturulma Tarihi
                                    @if(request('sort') == 'created_at')
                                        <i class="fas fa-sort-{{ request('direction') == 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </a>
                            </th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($serviceRecords as $record)
                            <tr>
                                <td>{{ $record->tracking_number }}</td>
                                <td>{{ $record->customer_name }}</td>
                                <td>{{ $record->device_model }}</td>
                                <td>
                                    <span class="badge bg-{{ $record->status_color }}">
                                        {{ $record->status_text }}
                                    </span>
                                </td>
                                <td>{{ $record->technician?->name ?? '-' }}</td>
                                <td>{{ $record->created_at->format('d.m.Y H:i') }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('service-records.show', $record) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @can('update', $record)
                                            <a href="{{ route('service-records.edit', $record) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan
                                        @can('delete', $record)
                                            <form action="{{ route('service-records.destroy', $record) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Bu servis kaydını silmek istediğinizden emin misiniz?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">Servis kaydı bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Sayfalama -->
            <div class="mt-4">
                {{ $serviceRecords->links() }}
            </div>
        </div>
    </div>
</div>
@endsection 