<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Servis Kaydı Detayı') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Cihaz Bilgileri -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Cihaz Bilgileri</h3>
                            <dl class="grid grid-cols-1 gap-4">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Marka</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->brand }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Model</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->model }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Seri No</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->serial_number }}</dd>
                                </div>
                            </dl>
                        </div>

                        <!-- Servis Durumu -->
                        <div>
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Servis Durumu</h3>
                            <dl class="grid grid-cols-1 gap-4">
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">İşlem Numarası</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->tracking_number }}</dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Durum</dt>
                                    <dd class="mt-1">
                                        @php
                                            $statusColors = [
                                                'pending' => 'bg-yellow-100 text-yellow-800',
                                                'in_progress' => 'bg-blue-100 text-blue-800',
                                                'waiting_for_parts' => 'bg-orange-100 text-orange-800',
                                                'completed' => 'bg-green-100 text-green-800',
                                                'cancelled' => 'bg-red-100 text-red-800'
                                            ];
                                            $statusTexts = [
                                                'pending' => 'Beklemede',
                                                'in_progress' => 'İşlemde',
                                                'waiting_for_parts' => 'Parça Bekliyor',
                                                'completed' => 'Tamamlandı',
                                                'cancelled' => 'İptal Edildi'
                                            ];
                                        @endphp
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColors[$serviceRecord->status] }}">
                                            {{ $statusTexts[$serviceRecord->status] }}
                                        </span>
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Son Güncelleme</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $serviceRecord->updated_at->format('d.m.Y H:i') }}</dd>
                                </div>
                            </dl>
                        </div>
                    </div>

                    <!-- Teknisyen Notları -->
                    @if($serviceRecord->notes->isNotEmpty())
                        <div class="mt-8">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Teknisyen Notları</h3>
                            <div class="space-y-4">
                                @foreach($serviceRecord->notes as $note)
                                    <div class="bg-gray-50 p-4 rounded-lg">
                                        <div class="flex justify-between items-start">
                                            <p class="text-sm text-gray-900">{{ $note->content }}</p>
                                            <span class="text-xs text-gray-500">{{ $note->created_at->format('d.m.Y H:i') }}</span>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <div class="mt-8 flex justify-end">
                        <a href="{{ route('service-query.index') }}"
                            class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                            Yeni Sorgulama
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 