<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Teknik Servis Personeli Atandı</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .content {
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #666;
        }
        .tracking-number {
            background-color: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            font-family: monospace;
            margin: 10px 0;
        }
        .technician-info {
            background-color: #e9f7fe;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
            margin: 15px 0;
        }
        .contact-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Teknik Servis Personeli Atandı</h2>
    </div>

    <div class="content">
        <p>Sayın {{ $serviceRecord->customer_name }},</p>

        <p>Servis kaydınıza teknik servis personeli atanmıştır. Aşağıda detaylı bilgileri bulabilirsiniz.</p>

        <div class="tracking-number">
            <strong>Takip Numarası:</strong> {{ $serviceRecord->tracking_number }}
        </div>

        <div class="technician-info">
            <h3>Atanan Teknik Servis Personeli</h3>
            <p>
                <strong>Ad Soyad:</strong> {{ $technician->name }}<br>
                <strong>Telefon:</strong> {{ $technician->phone }}<br>
                <strong>E-posta:</strong> {{ $technician->email }}
            </p>
            <p>
                <strong>Atayan Yetkili:</strong> {{ $assignedBy->name }}
            </p>
        </div>

        <p>
            Servis kaydınızın detaylarını görüntülemek için aşağıdaki butona tıklayabilirsiniz:
        </p>

        <p style="text-align: center;">
            <a href="{{ route('service-records.show', $serviceRecord->id) }}" class="button">
                Servis Kaydını Görüntüle
            </a>
        </p>

        <div class="contact-info">
            <h3>İletişim Bilgileri</h3>
            <p>
                <strong>Telefon:</strong> {{ config('app.phone') }}<br>
                <strong>E-posta:</strong> {{ config('app.email') }}<br>
                <strong>Adres:</strong> {{ config('app.address') }}
            </p>
        </div>

        <p>
            Teknik servis personelimiz en kısa sürede sizinle iletişime geçecektir.
            Herhangi bir sorunuz olursa yukarıdaki iletişim bilgilerinden bize ulaşabilirsiniz.
        </p>
    </div>

    <div class="footer">
        <p>Bu e-posta otomatik olarak gönderilmiştir. Lütfen yanıtlamayınız.</p>
        <p>&copy; {{ date('Y') }} {{ config('app.name') }}. Tüm hakları saklıdır.</p>
    </div>
</body>
</html> 