@props(['serviceRecord' => null, 'technicians' => collect()])

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ $serviceRecord ? route('service-records.update', $serviceRecord) : route('service-records.store') }}">
            @csrf
            @if($serviceRecord)
                @method('PUT')
            @endif

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="customer_name" class="form-label">Müşteri Adı</label>
                        <input type="text" class="form-control @error('customer_name') is-invalid @enderror" id="customer_name" name="customer_name" value="{{ old('customer_name', $serviceRecord?->customer_name) }}" required>
                        @error('customer_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="customer_phone" class="form-label">Müşteri Telefonu</label>
                        <input type="text" class="form-control @error('customer_phone') is-invalid @enderror" id="customer_phone" name="customer_phone" value="{{ old('customer_phone', $serviceRecord?->customer_phone) }}" required>
                        @error('customer_phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="customer_email" class="form-label">Müşteri E-posta</label>
                        <input type="email" class="form-control @error('customer_email') is-invalid @enderror" id="customer_email" name="customer_email" value="{{ old('customer_email', $serviceRecord?->customer_email) }}">
                        @error('customer_email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="customer_address" class="form-label">Müşteri Adresi</label>
                        <input type="text" class="form-control @error('customer_address') is-invalid @enderror" id="customer_address" name="customer_address" value="{{ old('customer_address', $serviceRecord?->customer_address) }}">
                        @error('customer_address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="device_brand" class="form-label">Cihaz Markası</label>
                        <input type="text" class="form-control @error('device_brand') is-invalid @enderror" id="device_brand" name="device_brand" value="{{ old('device_brand', $serviceRecord?->device_brand) }}" required>
                        @error('device_brand')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="device_model" class="form-label">Cihaz Modeli</label>
                        <input type="text" class="form-control @error('device_model') is-invalid @enderror" id="device_model" name="device_model" value="{{ old('device_model', $serviceRecord?->device_model) }}" required>
                        @error('device_model')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="device_serial_number" class="form-label">Seri Numarası</label>
                        <input type="text" class="form-control @error('device_serial_number') is-invalid @enderror" id="device_serial_number" name="device_serial_number" value="{{ old('device_serial_number', $serviceRecord?->device_serial_number) }}" required>
                        @error('device_serial_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="fault_description" class="form-label">Arıza Açıklaması</label>
                <textarea class="form-control @error('fault_description') is-invalid @enderror" id="fault_description" name="fault_description" rows="3" required>{{ old('fault_description', $serviceRecord?->fault_description) }}</textarea>
                @error('fault_description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">Durum</label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                            @foreach(\App\Models\ServiceRecord::STATUSES as $key => $value)
                                <option value="{{ $key }}" {{ old('status', $serviceRecord?->status) == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="technician_id" class="form-label">Teknisyen</label>
                        <select class="form-select @error('technician_id') is-invalid @enderror" id="technician_id" name="technician_id">
                            <option value="">Teknisyen Seçin</option>
                            @foreach($technicians as $technician)
                                <option value="{{ $technician->id }}" {{ old('technician_id', $serviceRecord?->technician_id) == $technician->id ? 'selected' : '' }}>{{ $technician->name }}</option>
                            @endforeach
                        </select>
                        @error('technician_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">Notlar</label>
                <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $serviceRecord?->notes) }}</textarea>
                @error('notes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="text-end">
                <a href="{{ route('service-records.index') }}" class="btn btn-secondary">İptal</a>
                <button type="submit" class="btn btn-primary">{{ $serviceRecord ? 'Güncelle' : 'Kaydet' }}</button>
            </div>
        </form>
    </div>
</div> 