<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            SMS Ayarları
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    @if (session('success'))
                        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                            <span class="block sm:inline">{{ session('success') }}</span>
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                            <span class="block sm:inline">{{ session('error') }}</span>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('admin.sms-settings.update') }}">
                        @csrf
                        @method('PUT')

                        <div class="grid grid-cols-1 gap-6">
                            <!-- Temel Ayarlar -->
                            <div class="space-y-4">
                                <h3 class="text-lg font-medium text-gray-900">Temel Ayarlar</h3>
                                
                                <div>
                                    <label for="header" class="block text-sm font-medium text-gray-700">SMS Başlığı</label>
                                    <input type="text" name="header" id="header" value="{{ old('header', $settings->header ?? '') }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>

                                <div>
                                    <label for="username" class="block text-sm font-medium text-gray-700">NetGSM Kullanıcı Adı</label>
                                    <input type="text" name="username" id="username" value="{{ old('username', $settings->username ?? '') }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>

                                <div>
                                    <label for="password" class="block text-sm font-medium text-gray-700">NetGSM Şifre</label>
                                    <input type="password" name="password" id="password" value="{{ old('password', $settings->password ?? '') }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>

                                <div>
                                    <label for="sender_number" class="block text-sm font-medium text-gray-700">Gönderici Numara</label>
                                    <input type="text" name="sender_number" id="sender_number" value="{{ old('sender_number', $settings->sender_number ?? '') }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                </div>

                                <div>
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" name="is_active" value="1" 
                                               {{ old('is_active', $settings->is_active ?? true) ? 'checked' : '' }}
                                               class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                        <span class="ml-2 text-sm text-gray-600">SMS Gönderimini Aktif Et</span>
                                    </label>
                                </div>
                            </div>

                            <!-- SMS Şablonları -->
                            <div class="space-y-4">
                                <h3 class="text-lg font-medium text-gray-900">SMS Şablonları</h3>
                                
                                <div>
                                    <label for="templates[assigned]" class="block text-sm font-medium text-gray-700">Tekniker Atandı</label>
                                    <textarea name="templates[assigned]" id="templates[assigned]" rows="3"
                                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>{{ old('templates.assigned', $settings->templates['assigned'] ?? '') }}</textarea>
                                    <p class="mt-1 text-sm text-gray-500">Değişkenler: {tracking_number}, {technician_name}</p>
                                </div>

                                <div>
                                    <label for="templates[in_progress]" class="block text-sm font-medium text-gray-700">Servis Başladı</label>
                                    <textarea name="templates[in_progress]" id="templates[in_progress]" rows="3"
                                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>{{ old('templates.in_progress', $settings->templates['in_progress'] ?? '') }}</textarea>
                                    <p class="mt-1 text-sm text-gray-500">Değişkenler: {tracking_number}</p>
                                </div>

                                <div>
                                    <label for="templates[waiting_parts]" class="block text-sm font-medium text-gray-700">Parça Bekleniyor</label>
                                    <textarea name="templates[waiting_parts]" id="templates[waiting_parts]" rows="3"
                                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>{{ old('templates.waiting_parts', $settings->templates['waiting_parts'] ?? '') }}</textarea>
                                    <p class="mt-1 text-sm text-gray-500">Değişkenler: {tracking_number}</p>
                                </div>

                                <div>
                                    <label for="templates[completed]" class="block text-sm font-medium text-gray-700">Servis Tamamlandı</label>
                                    <textarea name="templates[completed]" id="templates[completed]" rows="3"
                                              class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>{{ old('templates.completed', $settings->templates['completed'] ?? '') }}</textarea>
                                    <p class="mt-1 text-sm text-gray-500">Değişkenler: {tracking_number}</p>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Ayarları Kaydet
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 