<?php

namespace Database\Seeders;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Database\Seeder;

class ServiceRecordSeeder extends Seeder
{
    public function run(): void
    {
        // Get admin user
        $admin = User::where('email', 'admin@example.com')->first();

        // Create technician users if they don't exist
        $technicians = User::where('role', 'technician')->get();
        if ($technicians->isEmpty()) {
            $technicians = User::factory()->count(5)->technician()->create();
        }

        // Create customer users if they don't exist
        $customers = User::where('role', 'customer')->get();
        if ($customers->isEmpty()) {
            $customers = User::factory()->count(10)->customer()->create();
        }

        // Create service records for each customer
        foreach ($customers as $customer) {
            // Create 1-3 service records per customer
            $recordCount = rand(1, 3);
            for ($i = 0; $i < $recordCount; $i++) {
                $status = ServiceRecord::STATUSES[array_rand(ServiceRecord::STATUSES)];
                $technician = $status !== ServiceRecord::STATUS_PENDING ? $technicians->random() : null;

                ServiceRecord::factory()
                    ->withCustomer($customer)
                    ->withTechnician($technician)
                    ->create([
                        'status' => $status,
                        'created_by' => $admin->id,
                    ]);
            }
        }
    }
} 