<?php

namespace Database\Seeders;

use App\Models\ServiceRecord;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ServiceRecordReportSeeder extends Seeder
{
    public function run()
    {
        // Test kullanıcıları oluştur
        $admin = User::factory()->create(['role' => 'admin']);
        $serviceManager = User::factory()->create(['role' => 'service_manager']);
        $serviceStaff = User::factory()->create(['role' => 'service_staff']);
        $technician1 = User::factory()->create(['role' => 'technician']);
        $technician2 = User::factory()->create(['role' => 'technician']);
        $customer1 = User::factory()->create(['role' => 'customer']);
        $customer2 = User::factory()->create(['role' => 'customer']);

        // Farklı durumlarda servis kayıtları oluştur
        $statuses = ['pending', 'in_progress', 'waiting_for_parts', 'completed', 'cancelled'];
        $technicians = [$technician1, $technician2];
        $customers = [$customer1, $customer2];

        // Son 30 gün için servis kayıtları oluştur
        for ($i = 0; $i < 50; $i++) {
            $status = $statuses[array_rand($statuses)];
            $technician = $technicians[array_rand($technicians)];
            $customer = $customers[array_rand($customers)];
            
            $createdAt = now()->subDays(rand(0, 30));
            $updatedAt = $createdAt->copy()->addHours(rand(1, 72));

            ServiceRecord::factory()->create([
                'status' => $status,
                'technician_id' => $technician->id,
                'customer_id' => $customer->id,
                'created_at' => $createdAt,
                'updated_at' => $status === 'completed' ? $updatedAt : null,
            ]);
        }
    }
} 