<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Rol alanı
            $table->string('role')->default('customer')->after('email');

            // İletişim bilgileri
            $table->string('phone')->nullable()->after('role');
            $table->text('address')->nullable()->after('phone');

            // Soft delete
            $table->softDeletes();
        });

        // Varsayılan admin kullanıcısı oluştur
        DB::table('users')->insert([
            'name' => 'Admin',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['role', 'phone', 'address']);
            $table->dropSoftDeletes();
        });
    }
}; 