<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('sms_settings', function (Blueprint $table) {
            $table->id();
            $table->string('header')->comment('SMS başlığı');
            $table->string('username')->comment('NetGSM kullanıcı adı');
            $table->string('password')->comment('NetGSM şifre');
            $table->string('sender_number')->comment('Gönderici numara');
            $table->json('templates')->comment('SMS şablonları');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('sms_settings');
    }
}; 