<?php

namespace Database\Factories;

use App\Models\ServiceRecord;
use App\Models\Technician;
use App\Models\Customer;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ServiceRecordFactory extends Factory
{
    protected $model = ServiceRecord::class;

    public function definition(): array
    {
        return [
            'technician_id' => Technician::factory(),
            'customer_id' => Customer::factory(),
            'created_by' => User::factory(),
            'title' => $this->faker->sentence,
            'description' => $this->faker->paragraph,
            'status' => $this->faker->randomElement(['pending', 'in_progress', 'completed', 'cancelled']),
            'priority' => $this->faker->randomElement(['low', 'medium', 'high']),
            'completion_time' => $this->faker->optional()->numberBetween(30, 240),
            'scheduled_date' => $this->faker->dateTimeBetween('now', '+1 month'),
            'completion_date' => $this->faker->optional()->dateTimeBetween('now', '+2 months'),
            'notes' => $this->faker->optional()->paragraph,
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}