<?php

namespace App\Providers;

use App\Events\ServiceStatusChanged;
use App\Events\TechnicianAssigned;
use App\Listeners\HandleServiceStatusChange;
use App\Listeners\HandleTechnicianAssignment;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        ServiceStatusChanged::class => [
            HandleServiceStatusChange::class,
        ],
        TechnicianAssigned::class => [
            HandleTechnicianAssignment::class,
        ],
    ];

    public function boot()
    {
        parent::boot();
    }
} 