<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user)
    {
        return $user->isAdmin() || $user->isServiceManager();
    }

    public function view(User $user, User $model)
    {
        return $user->isAdmin() || $user->isServiceManager() || $user->id === $model->id;
    }

    public function create(User $user)
    {
        return $user->isAdmin() || $user->isServiceManager();
    }

    public function update(User $user, User $model)
    {
        // Admin herkesi düzenleyebilir
        if ($user->isAdmin()) {
            return true;
        }

        // Servis yöneticisi sadece kendisini ve servis personelini düzenleyebilir
        if ($user->isServiceManager()) {
            return $user->id === $model->id || $model->isServiceStaff();
        }

        // Diğer kullanıcılar sadece kendilerini düzenleyebilir
        return $user->id === $model->id;
    }

    public function delete(User $user, User $model)
    {
        // Admin herkesi silebilir
        if ($user->isAdmin()) {
            return true;
        }

        // Servis yöneticisi sadece servis personelini silebilir
        if ($user->isServiceManager()) {
            return $model->isServiceStaff();
        }

        return false;
    }

    public function restore(User $user, User $model)
    {
        return $user->isAdmin() || ($user->isServiceManager() && $model->isServiceStaff());
    }
} 