<?php

namespace App\Notifications;

use App\Models\ServiceRecord;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ServiceRecordStatusChanged extends Notification implements ShouldQueue
{
    use Queueable;

    public $serviceRecord;
    public $newStatus;
    public $description;

    public function __construct(ServiceRecord $serviceRecord, string $newStatus, ?string $description = null)
    {
        $this->serviceRecord = $serviceRecord;
        $this->newStatus = $newStatus;
        $this->description = $description;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Servis Kaydı Durumu Değişti')
            ->line('Servis kaydınızın durumu değiştirildi.')
            ->line('Yeni Durum: ' . $this->newStatus)
            ->line('Açıklama: ' . ($this->description ?? 'Açıklama yok'))
            ->action('Servis Kaydını Görüntüle', route('service-records.show', $this->serviceRecord));
    }
} 