<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ServiceTechnicianAssignment extends Model
{
    protected $fillable = [
        'service_record_id',
        'old_technician_id',
        'new_technician_id',
        'notes',
        'assigned_by_id',
    ];

    /**
     * Get the service record this assignment belongs to
     */
    public function serviceRecord(): BelongsTo
    {
        return $this->belongsTo(ServiceRecord::class);
    }

    /**
     * Get the previous technician
     */
    public function oldTechnician(): BelongsTo
    {
        return $this->belongsTo(User::class, 'old_technician_id');
    }

    /**
     * Get the new technician
     */
    public function newTechnician(): BelongsTo
    {
        return $this->belongsTo(User::class, 'new_technician_id');
    }

    /**
     * Get the user who made the assignment
     */
    public function assignedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assigned_by_id');
    }
} 