<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ServiceStatusChange extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_record_id',
        'old_status',
        'new_status',
        'changed_by_id',
        'description',
        'changed_at'
    ];

    protected $casts = [
        'changed_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function serviceRecord(): BelongsTo
    {
        return $this->belongsTo(ServiceRecord::class);
    }

    public function changedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'changed_by_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($statusChange) {
            $statusChange->changed_at = now();
        });
    }
} 