<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceItem extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'service_record_id',
        'type',
        'brand',
        'model',
        'serial_number',
        'description',
        'specifications',
        'condition_on_receipt',
        'accessories'
    ];

    protected $casts = [
        'specifications' => 'json',
        'accessories' => 'json'
    ];

    // Relationships
    public function serviceRecord()
    {
        return $this->belongsTo(ServiceRecord::class);
    }

    // Scopes
    public function scopeType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function scopeBrand($query, $brand)
    {
        return $query->where('brand', $brand);
    }

    // Helper Methods
    public function addSpecification($key, $value)
    {
        $specs = $this->specifications ?? [];
        $specs[$key] = $value;
        $this->specifications = $specs;
        return $this->save();
    }

    public function addAccessory($accessory)
    {
        $accessories = $this->accessories ?? [];
        $accessories[] = $accessory;
        $this->accessories = array_unique($accessories);
        return $this->save();
    }

    public function removeAccessory($accessory)
    {
        $accessories = $this->accessories ?? [];
        $this->accessories = array_values(array_diff($accessories, [$accessory]));
        return $this->save();
    }
}
