<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Device extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'brand',
        'model',
        'serial_number',
        'type',
        'specifications',
        'notes'
    ];

    protected $casts = [
        'specifications' => 'json'
    ];

    public function serviceRecords()
    {
        return $this->hasMany(ServiceRecord::class);
    }

    public function scopeType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function scopeBrand($query, $brand)
    {
        return $query->where('brand', $brand);
    }

    public function scopeModel($query, $model)
    {
        return $query->where('model', $model);
    }

    public function scopeSerialNumber($query, $serialNumber)
    {
        return $query->where('serial_number', $serialNumber);
    }
} 