<?php

namespace App\Mail;

use App\Models\ServiceRecord;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ServiceStatusUpdated extends Mailable
{
    use Queueable, SerializesModels;

    public $serviceRecord;
    public $oldStatus;
    public $newStatus;
    public $description;

    /**
     * Create a new message instance.
     */
    public function __construct(ServiceRecord $serviceRecord, string $oldStatus, string $newStatus, ?string $description = null)
    {
        $this->serviceRecord = $serviceRecord;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
        $this->description = $description;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Servis Kaydınızın Durumu Güncellendi',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.service-status-updated',
            with: [
                'serviceRecord' => $this->serviceRecord,
                'oldStatus' => $this->oldStatus,
                'newStatus' => $this->newStatus,
                'description' => $this->description,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
} 