<?php

namespace App\Listeners;

use App\Events\TechnicianAssigned;
use App\Notifications\TechnicianAssigned as TechnicianAssignedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class HandleTechnicianAssignment implements ShouldQueue
{
    use InteractsWithQueue;

    public function handle(TechnicianAssigned $event)
    {
        // Teknisyene bildirim gönder
        $event->technician->notify(
            new TechnicianAssignedNotification(
                $event->serviceRecord,
                $event->assignedBy
            )
        );

        // Müşteriye bildirim gönder
        if ($event->notifyCustomer && $event->serviceRecord->customer) {
            $event->serviceRecord->customer->notify(
                new TechnicianAssignedNotification(
                    $event->serviceRecord,
                    $event->assignedBy,
                    $event->technician
                )
            );
        }
    }
} 