<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'role' => $this->role,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'relationships' => [
                'assigned_services' => ServiceRecordResource::collection($this->whenLoaded('assignedServices')),
                'created_services' => ServiceRecordResource::collection($this->whenLoaded('createdServices')),
                'service_statuses' => ServiceStatusResource::collection($this->whenLoaded('serviceStatuses'))
            ]
        ];
    }
} 