<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceStatusResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'service_record_id' => $this->service_record_id,
            'status' => $this->status,
            'description' => $this->description,
            'created_by' => $this->created_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'relationships' => [
                'service_record' => new ServiceRecordResource($this->whenLoaded('serviceRecord')),
                'creator' => new UserResource($this->whenLoaded('creator'))
            ]
        ];
    }
} 