<?php

namespace App\Http\Requests\ServiceStatus;

use Illuminate\Foundation\Http\FormRequest;

class StoreServiceStatusRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'status' => 'required|string',
            'description' => 'nullable|string',
            'notify_customer' => 'boolean'
        ];
    }

    public function messages(): array
    {
        return [
            'status.required' => 'Durum alanı zorunludur.',
            'description.string' => 'Açıklama geçersiz formatta.',
            'notify_customer.boolean' => 'Müşteri bildirimi geçersiz.'
        ];
    }
} 