<?php

namespace App\Http\Requests\ServiceRecord;

use Illuminate\Foundation\Http\FormRequest;

class StoreServiceRecordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'customer_id' => 'required|exists:customers,id',
            'module_type' => 'required|string',
            'priority' => 'required|in:low,normal,high,urgent',
            'problem_description' => 'required|string',
            'estimated_completion' => 'nullable|date',
            'assigned_technician_id' => 'nullable|exists:users,id',
            'is_warranty' => 'boolean',
            'items' => 'nullable|array',
            'items.*.type' => 'required|string',
            'items.*.brand' => 'required|string',
            'items.*.model' => 'required|string',
            'items.*.serial_number' => 'nullable|string',
            'items.*.description' => 'nullable|string',
            'items.*.specifications' => 'nullable|array',
            'items.*.condition_on_receipt' => 'nullable|string',
            'items.*.accessories' => 'nullable|array'
        ];
    }

    public function messages(): array
    {
        return [
            'customer_id.required' => 'Müşteri seçimi zorunludur.',
            'customer_id.exists' => 'Geçersiz müşteri seçimi.',
            'module_type.required' => 'Modül tipi zorunludur.',
            'priority.required' => 'Öncelik seçimi zorunludur.',
            'priority.in' => 'Geçersiz öncelik seçimi.',
            'problem_description.required' => 'Problem açıklaması zorunludur.',
            'estimated_completion.date' => 'Geçerli bir tarih giriniz.',
            'assigned_technician_id.exists' => 'Geçersiz teknisyen seçimi.',
            'is_warranty.boolean' => 'Garanti durumu geçersiz.',
            'items.array' => 'Ürünler geçersiz formatta.',
            'items.*.type.required' => 'Ürün tipi zorunludur.',
            'items.*.brand.required' => 'Ürün markası zorunludur.',
            'items.*.model.required' => 'Ürün modeli zorunludur.'
        ];
    }
} 