<?php

namespace App\Http\Controllers;

use App\Models\ServiceRecord;
use Illuminate\Http\Request;

class ServiceRecordQueryController extends Controller
{
    public function index()
    {
        return view('service-record-query.index');
    }

    public function query(Request $request)
    {
        $request->validate([
            'phone' => 'required|string',
            'tracking_number' => 'required|string'
        ]);

        $serviceRecord = ServiceRecord::where('customer_phone', $request->phone)
            ->where('tracking_number', $request->tracking_number)
            ->with(['technician', 'notes'])
            ->first();

        if (!$serviceRecord) {
            return back()->with('error', 'Servis kaydı bulunamadı. Lütfen bilgilerinizi kontrol ediniz.');
        }

        return view('service-record-query.result', compact('serviceRecord'));
    }
} 