<?php

namespace App\Http\Controllers\Api\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class CustomerNotificationController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $notificationPreferences = [
            'email_notifications' => $user->email_notifications ?? true,
            'sms_notifications' => $user->sms_notifications ?? false,
            'service_status_updates' => $user->service_status_updates ?? true,
            'new_service_created' => $user->new_service_created ?? true,
            'service_completed' => $user->service_completed ?? true,
        ];

        return response()->json($notificationPreferences);
    }

    public function update(Request $request)
    {
        $user = Auth::user();

        $validated = $request->validate([
            'email_notifications' => 'boolean',
            'sms_notifications' => 'boolean',
            'service_status_updates' => 'boolean',
            'new_service_created' => 'boolean',
            'service_completed' => 'boolean',
        ]);

        $user->update($validated);

        return response()->json([
            'message' => 'Notification preferences updated successfully',
            'preferences' => $validated
        ]);
    }
} 